function getDocumentBits(){
    var bits = 0;
    if (app.activeDocument.bitsPerChannel == BitsPerChannelType.ONE) bits = 1;
    if (app.activeDocument.bitsPerChannel == BitsPerChannelType.EIGHT) bits = 8;
    if (app.activeDocument.bitsPerChannel == BitsPerChannelType.SIXTEEN) bits = 16;
    if (app.activeDocument.bitsPerChannel == BitsPerChannelType.THIRTYTWO) bits = 32;
    return bits;
}
if (app.documents.length > 0) {
    if ((getDocumentBits() == 8)||(getDocumentBits() == 16)){
Lark = function () {
var _hexToBin = 
function (h) {
  function binMap(n) {
    if (n.match(/[0-9]/)) return parseInt(n);
    return parseInt((n.charCodeAt(0) - 'A'.charCodeAt(0)) + 10);
  }

  h = h.toUpperCase().replace(/\s/g, '');
  var bytes = '';

  for (var i = 0; i < h.length/2; i++) {
    var hi = h.charAt(i * 2);
    var lo = h.charAt(i * 2 + 1);
    var b = (binMap(hi) << 4) + binMap(lo);
    bytes += String.fromCharCode(b);
  }
  return bytes;
};
   // =======================================================
var idMk = charIDToTypeID( "Mk  " );
    var desc47 = new ActionDescriptor();
    var idnull = charIDToTypeID( "null" );
        var ref34 = new ActionReference();
        var idAdjL = charIDToTypeID( "AdjL" );
        ref34.putClass( idAdjL );
    desc47.putReference( idnull, ref34 );
    var idUsng = charIDToTypeID( "Usng" );
        var desc48 = new ActionDescriptor();
        var idType = charIDToTypeID( "Type" );
        var idcolorLookup = stringIDToTypeID( "colorLookup" );
        desc48.putClass( idType, idcolorLookup );
    var idAdjL = charIDToTypeID( "AdjL" );
    desc47.putObject( idUsng, idAdjL, desc48 );
executeAction( idMk, desc47, DialogModes.NO );

// =======================================================
var idsetd = charIDToTypeID( "setd" );
    var desc49 = new ActionDescriptor();
    var idnull = charIDToTypeID( "null" );
        var ref35 = new ActionReference();
        var idAdjL = charIDToTypeID( "AdjL" );
        var idOrdn = charIDToTypeID( "Ordn" );
        var idTrgt = charIDToTypeID( "Trgt" );
        ref35.putEnumerated( idAdjL, idOrdn, idTrgt );
    desc49.putReference( idnull, ref35 );
    var idT = charIDToTypeID( "T   " );
        var desc50 = new ActionDescriptor();
        var idlookupType = stringIDToTypeID( "lookupType" );
        var idcolorLookupType = stringIDToTypeID( "colorLookupType" );
        var idthreeDLUT = stringIDToTypeID( "3DLUT" );
        desc50.putEnumerated( idlookupType, idcolorLookupType, idthreeDLUT );
        var idNm = charIDToTypeID( "Nm  " );
        desc50.putString( idNm, """Lark""" );
        var idprofile = stringIDToTypeID( "profile" );
        desc50.putData( idprofile, _hexToBin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
        var idLUTFormat = stringIDToTypeID( "LUTFormat" );
        var idLUTFormatType = stringIDToTypeID( "LUTFormatType" );
        var idLUTFormatthreeDL = stringIDToTypeID( "LUTFormat3DL" );
        desc50.putEnumerated( idLUTFormat, idLUTFormatType, idLUTFormatthreeDL );
        var idLUTthreeDFileData = stringIDToTypeID( "LUT3DFileData" );
        desc50.putData( idLUTthreeDFileData, _hexToBin("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"));
        var idLUTthreeDFileName = stringIDToTypeID( "LUT3DFileName" );
        desc50.putString( idLUTthreeDFileName, """Lark""" );
    var idcolorLookup = stringIDToTypeID( "colorLookup" );
    desc49.putObject( idT, idcolorLookup, desc50 );
executeAction( idsetd, desc49, DialogModes.NO );

// =======================================================
var idslct = charIDToTypeID( "slct" );
    var desc51 = new ActionDescriptor();
    var idnull = charIDToTypeID( "null" );
        var ref36 = new ActionReference();
        var idChnl = charIDToTypeID( "Chnl" );
        var idChnl = charIDToTypeID( "Chnl" );
        var idRGB = charIDToTypeID( "RGB " );
        ref36.putEnumerated( idChnl, idChnl, idRGB );
    desc51.putReference( idnull, ref36 );
    var idMkVs = charIDToTypeID( "MkVs" );
    desc51.putBoolean( idMkVs, false );
executeAction( idslct, desc51, DialogModes.NO );

// =======================================================
var idsetd = charIDToTypeID( "setd" );
    var desc52 = new ActionDescriptor();
    var idnull = charIDToTypeID( "null" );
        var ref37 = new ActionReference();
        var idLyr = charIDToTypeID( "Lyr " );
        var idOrdn = charIDToTypeID( "Ordn" );
        var idTrgt = charIDToTypeID( "Trgt" );
        ref37.putEnumerated( idLyr, idOrdn, idTrgt );
    desc52.putReference( idnull, ref37 );
    var idT = charIDToTypeID( "T   " );
        var desc53 = new ActionDescriptor();
        var idNm = charIDToTypeID( "Nm  " );
        desc53.putString( idNm, """Lark""" );
    var idLyr = charIDToTypeID( "Lyr " );
    desc52.putObject( idT, idLyr, desc53 );
executeAction( idsetd, desc52, DialogModes.NO );
};
Lark();    
           } else {
        alert("Active document must be 8-bit or 16-bit");
    }
} else {
    alert("At least one file must be opened");
}
